"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const typedi_1 = require("typedi");
const __1 = tslib_1.__importDefault(require(".."));
const api_response_1 = require("../../Utils/api_response");
const courseAdapter_1 = tslib_1.__importDefault(require("../../Database/adapters/courseAdapter"));
const jspdf_1 = require("../../Utils/pdf/jspdf");
// import { generatePDF } from "../../Utils/pdf/PDFkit";
let CourseController = class CourseController extends __1.default {
    constructor(courseAdapter) {
        super();
        this.courseAdapter = courseAdapter;
        this.getAllCourses = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { stream } = req.params;
                const courses = yield this.courseAdapter.DBGetAllCourses(stream);
                console.log(courses);
                return (0, api_response_1.success)(res, courses);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.getMyCourses = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { auth_user } = req.body;
                const courses = yield this.courseAdapter.DBGetMyCourses(auth_user.id);
                return (0, api_response_1.success)(res, courses);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.register = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { auth_user, ids, session } = req.body;
                yield this.courseAdapter.DBRegister(auth_user.id, ids, session.id, auth_user.level);
                return (0, api_response_1.successAction)(res, 'Registration successful');
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.generateCourseForm = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { auth_user, session } = req.body;
                console.log('in test mode');
                const courses = yield this.courseAdapter.DBGetMyCourses(auth_user.id);
                // const columns = ["Course Code", "Title", "Units", "Semester", "Course Status"];
                // const overall = [];
                // for (let d of courses) {
                //     const current = []
                //     // console.log(d);
                //     for (let col of columns) {
                //         // console.log(col, 'col')
                //         for (let key in d) {
                //             // console.log(key, 'key')
                //             if (col.toLowerCase().includes(key))
                //                 current.push(d[key])
                //         }
                //     }
                //     // console.log(current);
                //     overall.push(current)
                // }
                // console.log(overall)
                const columnKeyMapping = {
                    "Course Code": "code",
                    "Title": "title",
                    "Units": "unit",
                    "Semester": "semester",
                    "Course Status": "type"
                };
                const overall = courses.map(course => {
                    const current = [];
                    for (let key of Object.keys(columnKeyMapping)) {
                        const colKey = columnKeyMapping[key];
                        if (course.hasOwnProperty(colKey)) {
                            current.push(course[colKey]);
                        }
                        else {
                            current.push('N/A');
                        }
                    }
                    return current;
                });
                (0, jspdf_1.generateCFPDF)(res, auth_user, overall);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.dropCourse = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { auth_user, session } = req.body;
                const { id } = req.params;
                yield this.courseAdapter.DBDropCourse(auth_user.id, +id, session.id);
                return (0, api_response_1.successAction)(res, 'Successfully dropped course');
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
    }
};
CourseController = tslib_1.__decorate([
    (0, typedi_1.Service)(),
    tslib_1.__metadata("design:paramtypes", [courseAdapter_1.default])
], CourseController);
;
exports.default = CourseController;
