"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const typedi_1 = require("typedi");
const __1 = tslib_1.__importDefault(require(".."));
const aspirantAdapter_1 = tslib_1.__importDefault(require("../../Database/adapters/aspirantAdapter"));
const jwt_1 = require("../../Utils/jwt");
// import { encodeOTP, generateToken } from "../../Utils/jwt";
const api_response_1 = require("../../Utils/api_response");
const factory_1 = require("../../Utils/factory");
const mailer_1 = require("../../Utils/mailer");
const nodemailer_1 = require("../../Utils/mailer/nodemailer");
const feeAdapter_1 = tslib_1.__importDefault(require("../../Database/adapters/feeAdapter"));
const enum_1 = require("../../types/enum");
const paystack_1 = tslib_1.__importDefault(require("../../Utils/paystack"));
const jspdf_1 = require("../../Utils/pdf/jspdf");
const path_1 = tslib_1.__importDefault(require("path"));
const multer_1 = require("../../Utils/multer");
// import { cleanupTempFiles, moveFilesToUserFolder } from "../../Utils/multer";
// import { cleanupTempFiles, moveFilesOutOfTempFolder } from "../../Utils/multer/index old_v2";
let AspirantController = class AspirantController extends __1.default {
    constructor(aspirantAdapter, feeAdapter, paystack) {
        super();
        this.aspirantAdapter = aspirantAdapter;
        this.feeAdapter = feeAdapter;
        this.paystack = paystack;
        this.test = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const fees = yield this.feeAdapter.DBTest();
                return (0, api_response_1.success)(res, fees);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.getProfProgrammes = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const programmes = yield this.aspirantAdapter.DBGetProfProgrammes();
                return (0, api_response_1.success)(res, programmes);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.getProfile = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { auth_user } = req.body;
                return (0, api_response_1.success)(res, Object.assign({}, auth_user));
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.signup = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { email, first_name, last_name, middle_name, phone, stream } = req.body;
                // const salt = await bcrypt.genSalt(10);
                // const password = bcrypt.hashSync(raw, salt);
                // const pin = pinGenerator(4);
                // const verification_code = encodeOTP(pin, email);
                const token = (0, jwt_1.generateProfAspirantFormToken)({ email, first_name, last_name, stream, middle_name, phone });
                const verification_link = `${process.env.TNM_CLIENT_URL}/aspirant/professional/fee/application_fee?token=${token}`;
                // const verification_link = `${process.env.TNM_CLIENT_URL}/auth/verify?code=${pin}&email=${email}&stream=${stream}`;
                const replacements = {
                    studentName: `${first_name} ${last_name}`,
                    companyName: process.env.COMPANY_NAME,
                    verificationLink: verification_link,
                    supportLink: process.env.SUPPORT_LINK
                };
                // Get email content with dynamic data
                const content = (0, mailer_1.generateContent)('/mails/email_verification.html', replacements);
                (0, nodemailer_1.sendMail)({ to: email, type: 'html', subject: 'Please verify your email', content });
                console.log(`verification mail sent to ${email}`);
                console.log(verification_link);
                return (0, api_response_1.successAction)(res, "Check your the email provided to continue");
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.verifyEmail = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { aspirant, session } = req.body;
            const { email, first_name, last_name, middle_name, stream } = aspirant;
            try {
                const fee = yield this.feeAdapter.DBGetProfFormFee(session.id);
                fee.charges = (0, factory_1.calculateCharges)(fee.amount);
                return (0, api_response_1.success)(res, { fee, aspirant: { first_name, last_name, middle_name, email, stream } });
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.login = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { email, session } = req.body;
                const aspirant = yield this.aspirantAdapter.DBGetProfAspirant(email);
                const token = (0, jwt_1.generateProfAspirantToken)({ id: aspirant.id, email, stream: aspirant.programme_stream, status: aspirant.status });
                return (0, api_response_1.success)(res, { token, aspirant, session }, "Logged in successfully");
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.getApplication = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { email, session } = req.body;
                const aspirant = yield this.aspirantAdapter.DBGetProfAspirant(email);
                // const token = generateProfAspirantToken({ id: aspirant.id, email, stream: aspirant.programme_stream, status: aspirant.status });
                // return success(res, { token, aspirant, session }, "Logged in successfully");
                return (0, api_response_1.success)(res, aspirant);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.apply = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { auth_user, middle_name, DOB, gender, qualification, years_of_exp, workplace, session } = req.body;
                const { email, first_name, last_name } = auth_user;
                const { stream } = req.params;
                yield this.aspirantAdapter.DBCreateApplication({ first_name, last_name, middle_name, DOB, gender, qualification, years_of_exp, workplace }, email, stream);
                yield (0, nodemailer_1.sendMail)({ to: email, type: 'html', subject: 'TNM Application', content: `Hello ${last_name} ${first_name}, Your application is under review, kindly check back in at most 24hrs later. Thanks for your interest` });
                console.log('sending mail to them tellig them their applicationn is under review and should check back in 24hrs', 'so they should be on the lookout, it gona be through the email they supplied');
                (0, nodemailer_1.sendMail)({ to: process.env.ADMISSION_EMAIL || 'hoismail1430@gmail.com', type: 'html', subject: 'One new application at TNM', content: `Hello, there is a new applicationn that's need to be responded to ASAP. Clickk on the link below to view\n ...... ` });
                console.log('sending maill to the admin too, notifying then of a new application');
                return (0, api_response_1.successAction)(res, "Application successful");
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        // NID
        this.register = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            var _a, _b;
            try {
                const { email, first_name, last_name, middle_name, DOB, phone, gender, jamb_reg, session } = req.body;
                // const { o_level, jamb_result } = req.files;
                const files = req.files;
                const { o_level, jamb_result } = files;
                console.log(req.files);
                console.log(req.body, 'body in contrl');
                const password = yield (0, factory_1.encodeLastName)(last_name);
                // let receipt: { [key: string]: object } = {};
                const programme = yield this.aspirantAdapter.DBGetProgrammeByStream(enum_1.Stream.FULL);
                const fee = yield this.feeAdapter.DBGetPUTMFee(session.id);
                let amount = fee.amount + (0, factory_1.calculateCharges)(fee.amount);
                amount *= 100;
                const transactionID = (0, factory_1.generateTransactionID)();
                fee[transactionID] = transactionID;
                // fileStore.set(email, {
                //     o_level: o_level[0].buffer.toString('base64'),
                //     jamb_result: jamb_result[0].buffer.toString('base64')
                // });
                const olevel_file_path = path_1.default.join((_a = process.env.UPLOAD_PATH) !== null && _a !== void 0 ? _a : 'public/uploads', o_level[0].filename); // path relative to public_html
                const jamb_result_file_path = path_1.default.join((_b = process.env.UPLOAD_PATH) !== null && _b !== void 0 ? _b : 'public/uploads', jamb_result[0].filename);
                const metadata = {
                    fee,
                    customer: {
                        first_name, last_name, middle_name, email, phone, DOB, gender, jamb_reg,
                        olevel_file_path, jamb_result_file_path,
                        o_level_mimetype: o_level[0].mimetype,
                        jamb_result_mimetype: jamb_result[0].mimetype
                    },
                    programme_id: programme.id,
                    stream: enum_1.Stream.FULL,
                    invoice_type: enum_1.Invoice_Type.PUTME
                };
                const payment = yield this.paystack.initializeTransaction({ email, amount: Math.ceil(amount), reference: transactionID, metadata, callback_url: `${process.env.TNM_CLIENT_URL}/aspirant/nid/login` });
                // return success(res, { url: payment.authorization_url, fee_id: fee.id });
                return (0, api_response_1.success)(res, { url: '#', fee_id: fee.id });
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.nidLogin = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { jamb_reg, session } = req.body;
                const aspirant = yield this.aspirantAdapter.DBGetAspirant(jamb_reg);
                const token = (0, jwt_1.generateAspirantToken)({ id: aspirant.id, email: aspirant.email, stream: aspirant.programme_stream, jamb_reg });
                return (0, api_response_1.success)(res, { token }, "Logged in successfully");
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.uploadAdmissiionLetter = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { auth_user } = req.body;
                // const { buffer, mimetype } = req.file!;
                const file = req.file;
                // await this.aspirantAdapter.DBUploadAdmissionLetter(auth_user.jamb_reg, { adm_letter: buffer.toString('base64'), adm_letter_mimetype: mimetype });
                // await this.aspirantAdapter.DBUploadAdmissionLetter(auth_user.jamb_reg, { adm_letter: buffer, adm_letter_mimetype: mimetype });
                yield this.aspirantAdapter.DBUploadAdmissionLetter(auth_user.jamb_reg, { adm_letter_path: file.path, adm_letter_mimetype: file.mimetype });
                return (0, api_response_1.successAction)(res);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        // NID Parrt Time
        this.partTimeApplication = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { email, first_name, last_name, middle_name, DOB, phone, gender, state_of_origin, lga, address, manual_o_level, session } = req.body;
                // const { o_level, jamb_result } = req.files;
                const files = req.files;
                const { o_level, passport } = files;
                console.log(req.files);
                console.log(req.body, 'body in contrl');
                const password = yield (0, factory_1.encodeLastName)(last_name);
                // let receipt: { [key: string]: object } = {};
                const programme = yield this.aspirantAdapter.DBGetProgrammeByStream(enum_1.Stream.PART);
                const fee = yield this.feeAdapter.DBGetPartApplicationFee(session.id);
                let amount = fee.amount + (0, factory_1.calculateCharges)(fee.amount);
                amount *= 100;
                const transactionID = (0, factory_1.generateTransactionID)();
                fee[transactionID] = transactionID;
                // const olevel_file_path = path.join(process.env.UPLOAD_PATH ?? 'public/uploads', o_level[0].filename); // path relative to public_html
                // const passport_file_path = path.join(process.env.UPLOAD_PATH ?? 'public/uploads', passport[0].filename);
                const olevel_file_path = o_level[0].path;
                const passport_file_path = passport[0].path;
                const reg_no = yield (0, factory_1.generateApplicationNo)();
                const new_aspirant = yield this.aspirantAdapter.DBPartApplication({
                    first_name, last_name, middle_name, email, phone, password, DOB, gender, state_of_origin, lga, address, manual_o_level,
                    o_level_path: olevel_file_path, o_level_mimetype: o_level[0].mimetype,
                    passport_path: passport_file_path, passport_mimetype: passport[0].mimetype
                }, reg_no, programme.id, session);
                // await moveFilesOutOfTempFolder(req.body.tempUploadDir);
                (0, nodemailer_1.sendMail)({ to: email, type: 'html', subject: 'PUTME Registration', content: `<div> Thanks for your interest in TNM Media Academy, kindly login to continue using your email and surname as the password </div> ` });
                return (0, api_response_1.successAction)(res, 'Application completed successfully. Kindly login to generate your application letter');
                // const metadata = {
                //     fee,
                //     customer: {
                //         first_name, last_name, middle_name, email, phone, DOB, gender, state_of_origin, lga, address,
                //         manual_o_level,
                //         olevel_file_path, passport_file_path,
                //         o_level_mimetype: o_level[0].mimetype, passport_mimetype: passport[0].mimetype
                //     },
                //     programme_id: programme.id,
                //     stream: Stream.PART,
                //     invoice_type: Invoice_Type.PART_FORM
                // };
                // const payment = await this.paystack.initializeTransaction({ email, amount: Math.ceil(amount), reference: transactionID, metadata, callback_url: `${process.env.TNM_CLIENT_URL}/aspirant/nid/login` })
                // return success(res, { url: payment.authorization_url, fee_id: fee.id });
                // return success(res, { url: '#', fee_id: fee.id });
            }
            catch (error) {
                // await cleanupTempFiles(req.body.tempUploadDir);
                if (req.body.uploadedFiles && req.body.uploadedFiles.length > 0) {
                    (0, multer_1.deleteFiles)(req.body.uploadedFiles);
                }
                this.catchError(error, res);
            }
        });
        this.partLogin = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { email, session } = req.body;
                const aspirant = yield this.aspirantAdapter.DBGetAspirantByEmail(email);
                const token = (0, jwt_1.generateAspirantToken)({ id: aspirant.id, email: aspirant.email, stream: aspirant.programme_stream });
                return (0, api_response_1.success)(res, { token }, "Logged in successfully");
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.generateApplicationForm = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { auth_user } = req.body;
                const output = yield (0, jspdf_1.generateApplicationForm)(auth_user);
                // Set the content type to application/pdf
                res.setHeader('Content-Type', 'application/pdf');
                // Suggest download file name
                res.setHeader('Content-Disposition', `attachment; filename=application-form-${auth_user.first_name.replace(/\s+/g, '-')}.pdf`);
                // Send the PDF as a buffer
                res.send(Buffer.from(output));
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
    }
};
AspirantController = tslib_1.__decorate([
    (0, typedi_1.Service)(),
    tslib_1.__param(0, (0, typedi_1.Inject)()),
    tslib_1.__metadata("design:paramtypes", [aspirantAdapter_1.default,
        feeAdapter_1.default,
        paystack_1.default])
], AspirantController);
;
exports.default = AspirantController;
