"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const typedi_1 = require("typedi");
const __1 = tslib_1.__importDefault(require(".."));
// import { nanoid } from "nanoid";
const bcrypt = tslib_1.__importStar(require("bcryptjs"));
const adminAdapter_1 = tslib_1.__importDefault(require("../../Database/adapters/adminAdapter"));
const api_response_1 = require("../../Utils/api_response");
const enum_1 = require("../../types/enum");
const jwt_1 = require("../../Utils/jwt");
const courseAdapter_1 = tslib_1.__importDefault(require("../../Database/adapters/courseAdapter"));
const exceljs_1 = require("../../Utils/exceljs");
const nodemailer_1 = require("../../Utils/mailer/nodemailer");
const path_1 = tslib_1.__importDefault(require("path"));
let AdminController = class AdminController extends __1.default {
    constructor(adminAdapter, courseAdapter) {
        super();
        this.adminAdapter = adminAdapter;
        this.courseAdapter = courseAdapter;
        this.login = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { email, id, role } = req.body;
            try {
                const token = (0, jwt_1.generateAdminToken)({ email, id, role });
                return (0, api_response_1.success)(res, { token }, "Logged in successfully");
                // const me = await this.adminAdapter.DBGetMe(id);
                // return success(res, { token, me }, "Logged in successfully");
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.getDashboardData = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const data = yield this.adminAdapter.DBGetDashboardData();
                return (0, api_response_1.success)(res, data);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.createAdmin = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { email, name, password, role_id } = req.body;
            try {
                const raw = password;
                const hash = bcrypt.hashSync(raw, 10);
                yield this.adminAdapter.DBCreateAdmin({ email, name, password: hash, role_id });
                (0, nodemailer_1.sendMail)({
                    to: email,
                    type: 'html',
                    subject: 'Account credentials',
                    content: `
                    <div>
                        <p> Use the following credentials to access the dashboard </p>
                        <p> email: ${email} </p>
                        <p> password: ${raw} </p>
                    </div>
                `
                });
                return (0, api_response_1.created)(res, null);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.getAdmins = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const admins = yield this.adminAdapter.DBGetAdmins();
                return (0, api_response_1.success)(res, admins);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.editAdmin = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { name, role_id, email } = req.body;
                const { id } = req.params;
                const admins = yield this.adminAdapter.DBEditAdmin(+id, { name, role_id, email });
                return (0, api_response_1.success)(res, admins);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.createAdminRole = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { title, description, permissions: raw_perms } = req.body;
            try {
                const permissions = raw_perms.reduce((acc, cur) => !acc ? cur : acc + enum_1.permission_divider + cur, '');
                const role = yield this.adminAdapter.DBCreateAdminRole({ title, description, permissions });
                return (0, api_response_1.created)(res, role);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.getRoles = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const roles = yield this.adminAdapter.DBGetRoles();
                return (0, api_response_1.success)(res, roles);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.getMe = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { auth_user } = req.body;
                const me = yield this.adminAdapter.DBGetMe(auth_user.id);
                return (0, api_response_1.success)(res, me);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.createCourse = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { code, title, description, unit, type, prog_level } = req.body;
                // const courses = await this.courseAdapter.createCourseV2({ code, title, unit, type, prog_level, description });
                return (0, api_response_1.success)(res, 'courses');
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.getAllSessions = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const sessions = yield this.adminAdapter.DBGetSessions();
                return (0, api_response_1.success)(res, sessions);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.getAllProgrammes = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const programmes = yield this.adminAdapter.DBGetAllProgrammes();
                return (0, api_response_1.success)(res, programmes);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.getProgrammeByCategory = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { stream } = req.params;
                const programme = yield this.adminAdapter.DBGetProgramme(stream);
                return (0, api_response_1.success)(res, programme);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.getStudents = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const students = yield this.adminAdapter.DBGetStudents();
                return (0, api_response_1.success)(res, students);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.getCourses = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { stream } = req.params;
                const courses = yield this.adminAdapter.DBGetCourses(stream);
                return (0, api_response_1.success)(res, courses);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.getACourse = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { stream, id } = req.params;
                const course = yield this.adminAdapter.DBGetACourse(stream, id);
                return (0, api_response_1.success)(res, course);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.getAssignedCourses = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { auth_user } = req.body;
                const { stream } = req.params;
                const assigned_courses = yield this.adminAdapter.DBGetAssignedCourses(auth_user.id, stream);
                return (0, api_response_1.success)(res, assigned_courses);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.assignStaff = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { stream, id } = req.params;
                const { admin_ids, session } = req.body;
                yield this.adminAdapter.DBAssignStaff(stream, id, admin_ids, session.id);
                return (0, api_response_1.successAction)(res);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.getAssignedStaff = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { stream, id } = req.params;
                const { session } = req.body;
                const staff = yield this.adminAdapter.DBGetAssignedStaff(stream, id, session.id);
                return (0, api_response_1.success)(res, staff);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.getPendingApplications = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { stream } = req.params;
                const applicatiions = yield this.adminAdapter.DBGetPendingApplications(stream);
                return (0, api_response_1.success)(res, applicatiions);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.getApplication = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { stream, id } = req.params;
                const application = yield this.adminAdapter.DBGetApplication(id, stream);
                return (0, api_response_1.success)(res, application);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.reviewApplication = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { id, stream } = req.params;
                const { status, comment, programme_id } = req.body;
                // if (stream === Stream.STANDARD) {
                //     await this.adminAdapter.DBReviewApplication(+id, stream, { programme_id, status });
                // } else {
                //     await this.adminAdapter.DBReviewApplication(+id, stream, { programme_id, status });
                // }
                yield this.adminAdapter.DBReviewApplication(+id, stream, { programme_id, status });
                // send comment along with noftification via mail
                return (0, api_response_1.successAction)(res);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.getCourseResult = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { id, session_id } = req.params;
                const result = yield this.adminAdapter.DBGetCourseResult(id, session_id);
                return (0, api_response_1.success)(res, result);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        // PROFESSIONAL
        // NID
        // STUDENT
        this.uploadResult = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { course_id, level, session, sheetName } = req.body;
                const { stream } = req.params;
                const { buffer, mimetype } = req.file;
                const base64String = buffer.toString('base64');
                console.log(course_id, 'course_id');
                const results = (0, exceljs_1.excelToJson)(buffer, sheetName);
                console.log(results, 'RESLST');
                // console.log(results, 'results');
                // const course = await this.courseAdapter.DBGetCourseById(+course_id);
                const getMatricNos = results.map(res => {
                    const matricKey = Object.keys(res).find(key => key.toLowerCase().includes('matric'));
                    return matricKey ? res[matricKey] : undefined;
                }).filter(m => m !== undefined);
                console.log(getMatricNos, 'getMatricNos');
                const students = yield this.adminAdapter.DBGetSelectedStudents(getMatricNos);
                console.log(students, 'STD');
                const updates = [];
                for (let student of students) {
                    let std_result;
                    for (let result of results) {
                        const matric_key = Object.keys(result).find(key => key.toLowerCase().includes('matric'));
                        const CA_key = Object.keys(result).find(key => key.toLowerCase().includes('ca'));
                        const exam_key = Object.keys(result).find(key => key.toLowerCase().includes('exam'));
                        console.log(result[matric_key], 'key');
                        console.log(student.matric_no, 'mat');
                        if (result[matric_key] === student.matric_no) {
                            std_result = result;
                            const obj = {
                                student_id: student.id, CA: result[CA_key], exam: result[exam_key], grade: (result[CA_key] + result[exam_key])
                            };
                            updates.push(obj);
                        }
                    }
                }
                // update result for the concerned students
                updates.length && (yield this.adminAdapter.DBUploadResultV2(updates, course_id, session.id, level));
                return (0, api_response_1.successAction)(res);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.getAllFee = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                console.log('getting');
                const fees = yield this.adminAdapter.DBGetAllFee();
                return (0, api_response_1.success)(res, fees);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.getOtherFee = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                console.log('getting');
                const fees = yield this.adminAdapter.DBGetOtherFee();
                return (0, api_response_1.success)(res, fees);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.setFee = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { name, amount, prog_level, programme_id, session, category, is_recurrent, session_id } = req.body;
                yield this.adminAdapter.DBSetFee({ name, amount, prog_level, programme_id, category, is_recurrent, session_id });
                return (0, api_response_1.successAction)(res);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.uploadAspirants = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { session_id, year, sheetName } = req.body;
                const { buffer, mimetype } = req.file;
                const base64String = buffer.toString('base64');
                // await this.adminAdapter.DBUploadPutmeResult(type, session, base64String, year);
                const aspirants = (0, exceljs_1.excelToJson)(buffer, sheetName);
                yield this.adminAdapter.DBUploadAspirants({ session_id: +session_id, file: buffer, mimetype, sheetName, year }, aspirants);
                return (0, api_response_1.successAction)(res);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.getAspirants = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const aspirants = yield this.adminAdapter.DBGetAspirants();
                return (0, api_response_1.success)(res, aspirants);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.viewAspirant = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { jamb_reg } = req.params;
                const aspirants = yield this.adminAdapter.DBViewAspirant(jamb_reg);
                return (0, api_response_1.success)(res, aspirants);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.uploadPutmeResults = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { type, session_id, year, sheetName } = req.body;
                const { buffer, mimetype } = req.file;
                const base64String = buffer.toString('base64');
                // await this.adminAdapter.DBUploadPutmeResult(type, session, base64String, year);
                const results = (0, exceljs_1.excelToJson)(buffer, sheetName);
                const aspirants = yield this.adminAdapter.DBGetAspirants();
                yield this.adminAdapter.DBUploadPutmeResult({ type, session_id: +session_id, file: buffer, mimetype, sheetName, year }, aspirants, results);
                return (0, api_response_1.successAction)(res);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.changeAspirantStatus = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { jamb_regs } = req.body;
                const { status } = req.query;
                yield this.adminAdapter.changeAspirantStatus(status, jamb_regs);
                return (0, api_response_1.successAction)(res);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.getAcceptedAspirants = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const aspirants = yield this.adminAdapter.DBGetAcceptedAspirants();
                return (0, api_response_1.success)(res, aspirants);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.getRejectedAspirants = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const aspirants = yield this.adminAdapter.DBGetRejectedAspirants();
                return (0, api_response_1.success)(res, aspirants);
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
        this.getStudentsByProgramme = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { programme_id } = req.params;
                const students = yield this.adminAdapter.DBGetStudentsByProgramme(+programme_id);
                return (0, api_response_1.success)(res, students);
            }
            catch (error) {
            }
        });
        this.download = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { file_path } = req.params;
            const decodedFilePath = decodeURIComponent(file_path);
            const filePath = path_1.default.join(__dirname, '..', '..', '..', decodedFilePath);
            res.sendFile(filePath, err => {
                if (err) {
                    console.error('Error sending file:', err);
                    res.status(500).send('Error downloading file');
                }
            });
        });
        this.testFileUpload = (req, res) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                console.log(req.body);
                console.log(req.file, 'file');
                // console.log(req, 'req')
            }
            catch (error) {
                return this.catchError(error, res);
            }
        });
    }
};
AdminController = tslib_1.__decorate([
    (0, typedi_1.Service)(),
    tslib_1.__metadata("design:paramtypes", [adminAdapter_1.default,
        courseAdapter_1.default])
], AdminController);
exports.default = AdminController;
