"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
require("reflect-metadata");
require("dotenv/config");
const express_1 = tslib_1.__importDefault(require("express"));
const typedi_1 = tslib_1.__importStar(require("typedi"));
const cors_1 = tslib_1.__importDefault(require("cors"));
const morgan_1 = tslib_1.__importDefault(require("morgan"));
const Routes_1 = tslib_1.__importDefault(require("./src/Routes"));
const adminAdapter_1 = tslib_1.__importDefault(require("./src/Database/adapters/adminAdapter"));
const express_fileupload_1 = tslib_1.__importDefault(require("express-fileupload"));
let App = class App {
    constructor(routerr, adminAdapter) {
        this.routerr = routerr;
        this.adminAdapter = adminAdapter;
        this.initializeRoutes = () => {
            this.app.use(this.routerr.path, this.routerr.router);
            this.app.use((0, express_fileupload_1.default)({
                limits: { fileSize: 50 * 1024 * 1024 },
            }));
        };
        this.app = (0, express_1.default)();
        this.env = process.env.NODE_ENV || 'development';
        // this.port = process.env.PORT || 7010;
        this.port = process.env.PORT;
        this.initializeMiddlewares();
        this.initializeRoutes();
    }
    initializeMiddlewares() {
        this.app.get('/', (req, res) => res.json({ msg: 'HELLOOOO' }));
        this.app.use((0, morgan_1.default)(process.env.LOG_FORMAT || 'dev'));
        this.app.use((0, cors_1.default)());
        this.app.use(express_1.default.json());
        this.app.use(express_1.default.urlencoded({ extended: true }));
        this.app.use((req, res, next) => {
            res.header('Access-Control-Expose-Headers', 'Content-Disposition');
            next();
        });
    }
    getServer() {
        return this.app;
    }
    listen() {
        this.app.listen(this.port, () => tslib_1.__awaiter(this, void 0, void 0, function* () {
            console.info(`=================================`);
            console.info(`======= ENV: ${this.env} ========`);
            console.info(`🚀 App listening on the port ${this.port}`);
            console.info(`=================================`);
            this.adminAdapter.DBCreateSuperAdmin().then(r => {
                console.info("Super admin account created successfully!");
            });
            process
                .on('unhandledRejection', (reason, p) => {
                console.error(reason, 'Unhandled Rejection at Promise', p);
            })
                .on('uncaughtException', err => {
                console.error(err, 'Uncaught Exception thrown');
                process.exit(1);
            });
        }));
    }
};
App = tslib_1.__decorate([
    (0, typedi_1.Service)(),
    tslib_1.__metadata("design:paramtypes", [Routes_1.default,
        adminAdapter_1.default])
], App);
const instance = typedi_1.default.get(App);
instance.listen();
const app = instance.getServer();
exports.default = app;
